<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use App\Models\Page\Page;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:pages');
    }

    public function index()
    {
        $pages = Page::orderBy('id', 'asc')
            ->get();

        return view('Admin.Page.index', compact(
            'pages'
        ));
    }

    public function create()
    {
        return view('Admin.Page.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|max:191',
            'slug' => 'required|max:191|unique:pages',
            'content' => 'required|max:100000',
            'status' => 'required|numeric|in:0,1',
            'header_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000000',
            'header_video' => 'nullable|max:10000000',
            'header_title' => 'nullable|max:191',
            'header_text' => 'nullable|max:511',
            'header_link' => 'nullable|max:511'
        ]);

        $hasHeader = false;
        $headerImage = null;
        if(!empty($request['header_image'])){
            $sizes = getimagesize($request['header_image']);
            $pathes = store_image($request['header_image'], $sizes[0], $sizes[1], '10', '10');
            $headerImage = $pathes['image_path'];
            $hasHeader = true;
        }
        $headerVideo = null;
        if(!empty($request['header_video'])){
            $file = $request['header_video'];
            $filename = $file->getClientOriginalName();
            $path = 'videos';
            $file->move($path, $filename);
            $headerVideo = $path.'/'.$filename;
            $hasHeader = true;
        }

        Page::create([
            'title' => $request['title'],
            'slug' => $request['slug'],
            'content' => $request['content'],
            'status' => $request['status'],
            'visit_count' => 0,
            'has_header' => $hasHeader,
            'header_image' => $headerImage,
            'header_video' => $headerVideo,
            'header_title' => $request['header_title'],
            'header_text' => $request['header_text'],
            'header_link' => $request['header|_link'],

            'seo_title' => $request['seo_title'],
            'seo_description' => $request['seo_description'],
            'seo_keywords' => $request['seo_keywords']
        ]);

        flash_message('success', __('labels.stored'), '');
        return redirect()->route('admin.page.page.index');
    }

    public function edit($id)
    {
        $page = Page::findOrFail($id);
        return view('Admin.Page.edit', compact(
            'page'
        ));
    }

    public function update(Request $request, $id)
    {
        $page = Page::findOrFail($id);

        $this->validate($request, [
            'title' => 'required|max:191',
            'slug' => 'required|max:191|unique:pages,slug,'.$page->id,
            'content' => 'required|max:100000',
            'status' => 'required|numeric|in:0,1',

            'header_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000000',
            'header_video' => 'nullable|max:10000000',
            'header_title' => 'nullable|max:191',
            'header_text' => 'nullable|max:511',
            'header_link' => 'nullable|max:511'
        ]);

        if(!empty($request['remove_header'])){
            $hasHeader = false;
            $headerImage = null;
            $headerVideo = null;
            $headerTitle = null;
            $headerText = null;
            $headerLink = null;
        }
        else{
            $headerTitle = $request['header_title'];
            $headerText = $request['header_text'];
            $headerLink = $request['header_link'];
            $hasHeader = $page->has_header;
            $headerImage = $page->header_image;
            if(!empty($request['header_image'])){
                $sizes = getimagesize($request['header_image']);
                $pathes = store_image($request['header_image'], $sizes[0], $sizes[1], '10', '10');
                $headerImage = $pathes['image_path'];
                $hasHeader = true;
            }
            $headerVideo = $page->header_video;
            if(!empty($request['header_video'])){
                $file = $request['header_video'];
                $filename = $file->getClientOriginalName();
                $path = 'videos';
                $file->move($path, $filename);
                $headerVideo = $path.'/'.$filename;
                $hasHeader = true;
            }
        }

        $page->update([
            'title' => $request['title'],
            'slug' => $request['slug'],
            'content' => $request['content'],
            'status' => $request['status'],
            'has_header' => $hasHeader,
            'header_image' => $headerImage,
            'header_video' => $headerVideo,
            'header_title' => $headerTitle,
            'header_text' => $headerText,
            'header_link' => $headerLink,

            'seo_title' => $request['seo_title'],
            'seo_description' => $request['seo_description'],
            'seo_keywords' => $request['seo_keywords']
        ]);

        flash_message('success', __('labels.updated'), '');
        return redirect()->route('admin.page.page.index');
    }

    public function destroy($id)
    {
        Page::findOrFail($id);
        Page::destroy($id);

        flash_message('info', __('labels.deleted'), '');
        return redirect()->route('admin.page.page.index');
    }
}
