<?php

namespace App\Http\Controllers\Admin\Menu;

use App\Http\Controllers\Controller;
use App\Models\Menu\Menu;
use App\Models\Menu\Item;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;

class MenuController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:menus');
    }

    public function index()
    {
        $menus = Menu::orderBy('created_at', 'asc')
            ->get();

        return view('Admin.Menu.index', compact(
            'menus'
        ));
    }

    public function create()
    {
        return view('Admin.Menu.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'position' => 'required',
            'title' => 'required|max:191',
            'status' => 'required|numeric|in:0,1'
        ]);

        Menu::create([
            'position' => $request['position'],
            'title' => $request['title'],
            'status' => $request['status']
        ]);

        flash_message('success', __('labels.alert_stored'), '');
        return redirect()->route('admin.menu.index');
    }

    public function edit($id)
    {
        $menu = Menu::findOrFail($id);
        return view('Admin.Menu.edit', compact(
            'menu'
        ));
    }

    public function update(Request $request, $id)
    {
        $menu = Menu::findOrFail($id);

        $this->validate($request, [
            'position' => 'required',
            'title' => 'required|max:191',
            'status' => 'required|numeric|in:0,1'
        ]);

        $menu->update([
            'position' => $request['position'],
            'title' => $request['title'],
            'status' => $request['status']
        ]);

        flash_message('success', __('labels.alert_stored'), '');
        return redirect()->route('admin.menu.index');
    }

    public function delete($id)
    {
        dd('Delete nemikhad!');

        $menu = Menu::findOrFail($id);
        DB::transaction(function() use($menu) {
            if(count($menu->items)){
                foreach($menu->items as $item){
                    Item::destroy($item->id);
                }
            }
            Menu::destroy($menu->id);
        });

        flash_message('info', __('labels.deleted_successfully'), '');
        return back();
    }

}




