<?php

namespace App\Http\Controllers\Admin\FirstPageStep;

use App\Http\Controllers\Controller;
use App\Models\FirstPageStep\Desc;
use Illuminate\Http\Request;

class DescController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:firstPageStep');
    }

    public function index()
    {
        $desc = Desc::first();

        if(empty($desc)){
            $desc = Desc::create([
                'status' => false,
                'title' => null,
                'step_one_number' => null,
                'step_one_title' => null,
                'step_one_text' => null,
                'step_two_number' => null,
                'step_two_title' => null,
                'step_two_text' => null,
                'step_three_number' => null,
                'step_three_title' => null,
                'step_three_text' => null
            ]);
        }

        return view('Admin.FirstPageStep.desc', compact(
            'desc'
        ));
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'status' => 'required|numeric|in:0,1',
            'title' => 'nullable|max:191',
            'step_one_number' => 'nullable|max:191',
            'step_one_title' => 'nullable|max:191',
            'step_one_text' => 'nullable|max:191',
            'step_two_number' => 'nullable|max:191',
            'step_two_title' => 'nullable|max:191',
            'step_two_text' => 'nullable|max:191',
            'step_three_number' => 'nullable|max:191',
            'step_three_title' => 'nullable|max:191',
            'step_three_text' => 'nullable|max:191',
        ],[
            'status.required' => 'وضعیت را تعیین کنید',
            'title.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_one_number..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_one_title..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_one_text..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_two_number..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_two_title..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_two_text..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_three_number..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_three_title..max' => 'کمتر از 191 کاراکتر وارد کنید',
            'step_three_text..max' => 'کمتر از 191 کاراکتر وارد کنید'
        ]);

        $desc = Desc::first();
        $desc->update([
            'status' => $request['status'],
            'title' => $request['title'],
            'step_one_number' => $request['step_one_number'],
            'step_one_title' => $request['step_one_title'],
            'step_one_text' => $request['step_one_text'],
            'step_two_number' => $request['step_two_number'],
            'step_two_title' => $request['step_two_title'],
            'step_two_text' => $request['step_two_text'],
            'step_three_number' => $request['step_three_number'],
            'step_three_title' => $request['step_three_title'],
            'step_three_text' => $request['step_three_text']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return back();
    }

}




