<?php

namespace App\Http\Controllers\Admin\FirstPageReceiveCapital;

use App\Http\Controllers\Controller;
use App\Models\FirstPageReceiveCapital\Desc;
use Illuminate\Http\Request;

class DescController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:firstPageReceiveCapital');
    }

    public function index()
    {
        $desc = Desc::first();

        if(empty($desc)){
            $desc = Desc::create([
                'status' => false,
                'title' => null
            ]);
        }

        return view('Admin.FirstPageReceiveCapital.desc', compact(
            'desc'
        ));
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'status' => 'required|numeric|in:0,1',
            'title' => 'nullable|max:191'
        ],[
            'status.required' => 'وضعیت را تعیین کنید',
            'title.max' => 'کمتر از 191 کاراکتر وارد کنید'
        ]);

        $desc = Desc::first();
        $desc->update([
            'status' => $request['status'],
            'title' => $request['title']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return back();
    }

}




