<?php

namespace App\Http\Controllers\Admin\FirstPageGuide;

use App\Http\Controllers\Controller;
use App\Models\FirstPageGuide\Item;
use Illuminate\Http\Request;

class ItemController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:firstPageGuide');
    }

    public function index()
    {
        $items = Item::orderBy('sort_order', 'asc')
            ->get();

        return view('Admin.FirstPageGuide.Item.index', compact(
            'items'
        ));
    }

    public function create()
    {
        return view('Admin.FirstPageGuide.Item.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'title' => 'required|max:191',
            'slug' => 'required|max:191|unique:first_page_challenge_items',
            'image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000',
            'header_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000',
            'status' => 'required|numeric|in:0,1'
        ],[
            'sort_order.required' => 'ترتیب نمایش را تعیین کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'title.required' => 'این فیلد را خالی رها نکنید',
            'title.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.required' => 'این فیلد را خالی رها نکنید',
            'slug.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.unique' => 'این فیلد را خالی رها نکنید',
            'image.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'image.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'image.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'header_image.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'header_image.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'header_image.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'status.required' => 'وضعیت را تعیین کنید'
        ]);

        $image = null;
        if(!empty($request['image'])){
            $file = $request['image'];
            $filename = time().$file->getClientOriginalName();
            $path = 'images/firstPageGuide';
            $file->move($path, $filename);
            $image = $path.'/'.$filename;
        }
        $headerImage = null;
        if(!empty($request['header_image'])){
            $sizes = getimagesize($request['header_image']);
            $headerImage = store_image($request['header_image'], 'firstPageGuide', $sizes[0], $sizes[1]);
        }

        Item::create([
            'sort_order' => $request['sort_order'],
            'title' => $request['title'],
            'slug' => $request['slug'],
            'text' => $request['text'],
            'image' => $image,
            'header_image' => $headerImage,
            'status' => $request['status']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.firstPageGuide.item.index');
    }

    public function edit($id)
    {
        $item = Item::findOrFail($id);

        return view('Admin.FirstPageGuide.Item.edit', compact(
            'item'
        ));
    }

    public function update(Request $request, $id)
    {
        $item = Item::findOrFail($id);

        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'title' => 'required|max:191',
            'slug' => 'required|max:191|unique:first_page_challenge_items,slug,'.$item->id,
            'image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000',
            'header_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000',
            'status' => 'required|numeric|in:0,1'
        ],[
            'sort_order.required' => 'ترتیب نمایش را تعیین کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'title.required' => 'این فیلد را خالی رها نکنید',
            'title.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.required' => 'این فیلد را خالی رها نکنید',
            'slug.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.unique' => 'این فیلد را خالی رها نکنید',
            'image.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'image.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'image.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'header_image.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'header_image.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'header_image.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'status.required' => 'وضعیت را تعیین کنید'
        ]);

        $image = $item->image ?? null;
        if(!empty($request['image'])){
            try{
                unlink($item->image);
            } catch(\Exception $e){}

            $file = $request['image'];
            $filename = time().$file->getClientOriginalName();
            $path = 'images/firstPageGuide';
            $file->move($path, $filename);
            $image = $path.'/'.$filename;
        }
        $headerImage = $item->header_image ?? null;
        if(!empty($request['header_image'])){
            try{
                unlink($item->header_image);
            } catch(\Exception $e){}

            $sizes = getimagesize($request['header_image']);
            $headerImage = store_image($request['header_image'], 'firstPageGuide', $sizes[0], $sizes[1]);
        }

        $item->update([
            'sort_order' => $request['sort_order'],
            'title' => $request['title'],
            'slug' => $request['slug'],
            'text' => $request['text'],
            'image' => $image,
            'header_image' => $headerImage,
            'status' => $request['status']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.firstPageGuide.item.index');
    }

    public function delete($id)
    {
        $item = Item::findOrFail($id);

        try{
            unlink($item->image);
            unlink($item->header_image);
        } catch(\Exception $e){}

        Item::destroy($id);

        flash_message('info', 'حذف شد', '');
        return back();
    }

}




