<?php

namespace App\Http\Controllers\Admin\FirstPageChallenge;

use App\Http\Controllers\Controller;
use App\Models\FirstPageChallenge\Desc;
use Illuminate\Http\Request;

class DescController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:firstPageChallenge');
    }

    public function index()
    {
        $desc = Desc::first();

        if(empty($desc)){
            $desc = Desc::create([
                'title_section_one' => null,
                'title_section_two' => null,
                'text' => null,
                'status' => false,
                'button_status' => false,
                'button_title' => null,
                'button_link' => null
            ]);
        }

        return view('Admin.FirstPageChallenge.desc', compact(
            'desc'
        ));
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'title_section_one' => 'nullable|max:191',
            'title_section_two' => 'nullable|max:191',
            'status' => 'required|numeric|in:0,1',
            'button_status' => 'required|numeric|in:0,1'
        ],[
            'title_section_one.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'title_section_two.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'status.required' => 'وضعیت را تعیین کنید',
            'button_status.required' => 'وضعیت را تعیین کنید'
        ]);

        $desc = Desc::first();
        $desc->update([
            'title_section_one' => $request['title_section_one'],
            'title_section_two' => $request['title_section_two'],
            'text' => $request['text'],
            'status' => $request['status'],
            'button_status' => $request['button_status'],
            'button_title' => $request['button_title'],
            'button_link' => $request['button_link']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return back();
    }

}




