<?php

namespace App\Http\Controllers\Admin\Faq;

use App\Http\Controllers\Controller;
use App\Models\Faq\Faq;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:faqs');
    }

    public function index()
    {
        $items = Faq::orderBy('sort_order', 'asc')
            ->get();

        return view('Admin.Faq.index', compact(
            'items'
        ));
    }

    public function create()
    {
        return view('Admin.Faq.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'show_in_first_page' => 'required|numeric|in:0,1',
            'status' => 'required|numeric|in:0,1',
            'question' => 'required',
            'answer' => 'required'
        ],[
            'sort_order.required' => 'ترتیب نمایش را وارد کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'status.required' => 'وضعیت را تعیین کنید',
            'show_in_first_page.required' => 'وضعیت نمایش در صفحه اصلی را مشخص کنید',
            'question.required' => 'متن سوال را وارد کنید',
            'answer.required' => 'متن پاسخ را وارد کنید'
        ]);

        Faq::create([
            'sort_order' => $request['sort_order'],
            'show_in_first_page' => $request['show_in_first_page'],
            'status' => $request['status'],
            'question' => $request['question'],
            'answer' => $request['answer']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.faq.index');
    }

    public function edit($id)
    {
        $item = Faq::findOrFail($id);

        return view('Admin.Faq.edit', compact(
            'item'
        ));
    }

    public function update(Request $request, $id)
    {
        $item = Faq::findOrFail($id);

        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'show_in_first_page' => 'required|numeric|in:0,1',
            'status' => 'required|numeric|in:0,1',
            'question' => 'required',
            'answer' => 'required'
        ],[
            'sort_order.required' => 'ترتیب نمایش را وارد کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'status.required' => 'وضعیت را تعیین کنید',
            'show_in_first_page.required' => 'وضعیت نمایش در صفحه اصلی را مشخص کنید',
            'question.required' => 'متن سوال را وارد کنید',
            'answer.required' => 'متن پاسخ را وارد کنید'
        ]);

        $item->update([
            'sort_order' => $request['sort_order'],
            'show_in_first_page' => $request['show_in_first_page'],
            'status' => $request['status'],
            'question' => $request['question'],
            'answer' => $request['answer']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.faq.index');
    }

    public function delete($id)
    {
        Faq::destroy($id);

        flash_message('info', 'حذف شد', '');
        return back();
    }

}




