<?php

namespace App\Http\Controllers\Admin\ContactUsPage;

use App\Http\Controllers\Controller;
use App\Models\ContactUsPage\Desc\ContactUsPage;
use App\Models\ContactUsPage\Message\ContactUsMessage;
use Illuminate\Http\Request;

class ContactUsController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:contact_us');
    }

    public function desc_index()
    {
        $contactUs = ContactUsPage::first();

        return view('Admin.ContactUsPage.Desc.index', compact(
            'contactUs'
        ));
    }

    public function desc_store(Request $request)
    {
        $this->validate($request, [
            'whole_page_status' => 'required|numeric|in:0,1',
            'slideshow_status' => 'required|numeric|in:0,1',
            'slideshow_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000000'
        ]);

        $contactUs = ContactUsPage::first();

        /*slideshow_image*/
        $slideshow_image = $contactUs->slideshow_image ?? null;
        if(!empty($request['slideshow_image'])){
            try{
                unlink($contactUs->slideshow_image);
            } catch(\Exception $e){}

            $file = $request['slideshow_image'];
            $filename = $file->getClientOriginalName();
            $path = 'images';
            $file->move($path, $filename);
            $slideshow_image = $path.'/'.$filename;
        }

        /*slideshow_items*/
        $slideshow_items_Array = null;
        $slideshow_items_sort_orders = $request['slideshow_items_sort_orders'];
        $slideshow_items_titles = $request['slideshow_items_titles'];
        $slideshow_items_images = $request['slideshow_items_images'];
        $slideshow_items_texts = $request['slideshow_items_texts'];
        $slideshow_items_button_titles = $request['slideshow_items_button_titles'];
        $slideshow_items_button_links = $request['slideshow_items_button_links'];
        if(!empty($slideshow_items_sort_orders)){
            if(count($slideshow_items_sort_orders)){
                foreach($slideshow_items_sort_orders as $key=>$slideshow_items_sort_order){
                    if(
                        $slideshow_items_sort_order != '' &&
                        $slideshow_items_titles[$key] != '' &&
                        $slideshow_items_images[$key] != '' &&
                        $slideshow_items_texts[$key] != '' &&
                        $slideshow_items_button_titles[$key] != '' &&
                        $slideshow_items_button_links[$key] != ''
                    ){
                        /*Upload image*/
                        $thisFilePath = null;
                        if(!empty($slideshow_items_images[$key])){
                            if(is_string($slideshow_items_images[$key])){
                                /*STRINGe*/
                                $thisFilePath = $slideshow_items_images[$key];
                            }
                            else{
                                /*FILEe*/
                                $file = $slideshow_items_images[$key];
                                $filename = time().$file->getClientOriginalName();
                                $path = 'images';
                                $file->move($path, $filename);
                                $thisFilePath = $path.'/'.$filename;
                            }
                        }

                        $slideshow_items_Array[] = [
                            'sort_order' => $slideshow_items_sort_order,
                            'title' => $slideshow_items_titles[$key],
                            'image' => $thisFilePath,
                            'text' => $slideshow_items_texts[$key],
                            'button_title' => $slideshow_items_button_titles[$key],
                            'button_link' => $slideshow_items_button_links[$key]
                        ];
                    }
                }
                $slideshow_items_Array = json_encode($slideshow_items_Array);
            }
        }


        if(!empty($contactUs)){
            $contactUs->update([
                'whole_page_status' => $request['whole_page_status'],
                'slideshow_status' => $request['slideshow_status'],
                'slideshow_image' => $slideshow_image,
                'slideshow_title' => $request['slideshow_title'],
                'slideshow_items' => $slideshow_items_Array,
                'body_one' => $request['body_one'],
                'body_two' => $request['body_two'],

                'seo_title' => $request['seo_title'],
                'seo_description' => $request['seo_description'],
                'seo_keywords' => $request['seo_keywords']
            ]);
        }
        else{
            ContactUsPage::create([
                'whole_page_status' => $request['whole_page_status'],
                'slideshow_status' => $request['slideshow_status'],
                'slideshow_image' => $slideshow_image,
                'slideshow_title' => $request['slideshow_title'],
                'slideshow_items' => $slideshow_items_Array,
                'body_one' => $request['body_one'],
                'body_two' => $request['body_two'],

                'seo_title' => $request['seo_title'],
                'seo_description' => $request['seo_description'],
                'seo_keywords' => $request['seo_keywords']
            ]);
        }

        flash_message('success', __('labels.stored'), '');
        return back();
    }


    /*Message*/
    public function message_index()
    {
        $messages = ContactUsMessage::orderBy('id', 'desc')
            ->get();

        return view('Admin.ContactUsPage.Message.index', compact(
            'messages'
        ));
    }
    public function message_show($id)
    {
        $message = ContactUsMessage::where('id', $id)
            ->firstOrFail();

        $message->update([
            'seened_by_admin' => true
        ]);

        return view('Admin.ContactUsPage.Message.show', compact(
            'message'
        ));
    }
    public function message_delete($id)
    {
        $message = ContactUsMessage::where('id', $id)
            ->firstOrFail();

        ContactUsMessage::destroy($id);


        flash_message('info', __('labels.deleted'), '');
        return redirect()->route('admin.contactUsPage.message.index');
    }


}




