<?php

namespace App\Http\Controllers\Admin\Blog;

use App\Http\Controllers\Controller;
use App\Models\Blog\ArticleCategory;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:blog');
    }

    public function index()
    {
        $items = ArticleCategory::orderBy('sort_order', 'asc')
            ->get();

        return view('Admin.Blog.Category.index', compact(
            'items'
        ));
    }

    public function create()
    {
        return view('Admin.Blog.Category.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'title' => 'required|max:191',
            'slug' => 'required|max:191|unique:article_categories',
            'status' => 'required|numeric|in:0,1'
        ],[
            'sort_order.required' => 'ترتیب نمایش را وارد کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'status.required' => 'وضعیت را تعیین کنید',
            'title.required' => 'عنوان را وارد کنید',
            'title.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.required' => 'نام دسترسی را وارد کنید',
            'slug.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.unique' => 'این نام دسترسی قبلا ثبت شده است',
        ]);

        ArticleCategory::create([
            'sort_order' => $request['sort_order'],
            'title' => $request['title'],
            'slug' => $request['slug'],
            'status' => $request['status']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.blog.category.index');
    }

    public function edit($id)
    {
        $item = ArticleCategory::findOrFail($id);

        return view('Admin.Blog.Category.edit', compact(
            'item'
        ));
    }

    public function update(Request $request, $id)
    {
        $item = ArticleCategory::findOrFail($id);

        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'title' => 'required|max:191',
            'slug' => 'required|max:191|unique:article_categories,slug,'.$item->id,
            'status' => 'required|numeric|in:0,1'
        ],[
            'sort_order.required' => 'ترتیب نمایش را وارد کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'status.required' => 'وضعیت را تعیین کنید',
            'title.required' => 'عنوان را وارد کنید',
            'title.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.required' => 'نام دسترسی را وارد کنید',
            'slug.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'slug.unique' => 'این نام دسترسی قبلا ثبت شده است',
        ]);

        $item->update([
            'sort_order' => $request['sort_order'],
            'title' => $request['title'],
            'slug' => $request['slug'],
            'status' => $request['status']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.blog.category.index');
    }

    public function delete($id)
    {
        ArticleCategory::destroy($id);

        flash_message('info', 'حذف شد', '');
        return back();
    }

}




