<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Models\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Auth\Events\Registered;

class RegisterController extends Controller
{
    use RegistersUsers;

    protected $redirectTo = '/admin';

    public function showRegistrationForm()
    {
        return view('Admin.Auth.Register');
    }

    public function __construct()
    {
        $this->middleware('guest');
    }


    public function register(Request $request)
    {
        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));

        $this->guard()->login($user);

        return $this->registered($request, $user)
            ?: redirect($this->redirectPath());
    }

    protected function validator(array $data)
    {
        return Validator::make($data, [
            'email' => ['required', 'email', 'max:255', 'unique:admins'],
            'mobile_number' => ['required', 'numeric', 'digits:11', 'unique:admins'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
            'accept_rules' => ['required'],
            /*'captcha' => 'required|captcha',*/
        ], [
            'email.unique' => 'این ایمیل قبلا وارد شده است.',
            'mobile_number.numeric' => 'لطفا عدد وارد کنید',
            'mobile_number.unique' => 'این شماره تلفن قبلا وارد شده است',
            'mobile_number.digits' => 'شماره تلفن وارد شده اشتباه است',
            'password.confirmed' => 'رمز شما مطابقت ندارد',
            'password.min' => 'رمز عبور باید حداقل 6 کاراکتر باشد',
            'accept_rules.required' => 'قوانین را مطالعه کرده و تیک آن را بزنید',
            /*'captcha.required' => 'کد امنیتی را وارد کنید',
            'captcha.captcha' => 'کد امنیتی وارد شده اشتباه است'*/
        ]);
    }

    protected function create(array $data)
    {
        return Admin::create([
            'email' => $data['email'],
            'mobile_number' => $data['mobile_number'],
            'password' => Hash::make($data['password']),
        ]);
    }

    protected function guard()
    {
        return \Auth::guard('admin');
    }

    protected function registered(Request $request, $user)
    {
        //
    }
}
