<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }

    /*Load AdminPanel*/
    public function admin_panel()
    {
        return view('Admin.index');
    }




    /*Show AdminInfo Page*/
    public function my_info()
    {
        $admin = \Auth::guard('admin')->user();
        return view('Admin.Admin.my_info', compact('admin'));
    }
    /*Update Admin Infos (Email or Password)*/
    public function my_info_update(Request $request, $id)
    {
        $admin = Admin::findOrFail($id);
        if($admin->id != \Auth::guard('admin')->user()->id){
            abort(404);
        }

        /*اگر فقط ایمیل رو خواست تغییر بده*/
        if(!empty($request['email'])){
            $this->validate($request, [
                'email' => 'required|email|unique:admins,email,'.$admin->id,
            ]);

            $admin->update([
                'email' => $request['email']
            ]);

            flash_message('success', __('labels.admin_email_changed'), '');
            return back();
        }

        /*اگر خواست رمز رو تغییر بده*/
        if(empty($request['email'])){

            if((\Hash::check($request['old_password'], $admin->password))){
                $this->validate($request, [
                    'old_password' => 'required',
                    'password' => 'required|string|min:6|confirmed',
                    'password_confirmation' => 'required'
                ]);

                $admin->update([
                    'password' => \Hash::make($request['password'])
                ]);
                flash_message('success', __('labels.admin_password_changed'), '');
                return back();
            }
            else{
                flash_message('danger', 'رمز وارد شده به عنوان رمز فعلی اشتباه است', '');
                return back();
            }
        }

    }
}
