<?php

namespace App\Http\Controllers\Admin\AboutUsPage;

use App\Http\Controllers\Controller;
use App\Models\AboutUsPage;
use Illuminate\Http\Request;

class AboutUsController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:about_us');
    }

    public function index()
    {
        $aboutUs = AboutUsPage::first();

        return view('Admin.AboutUsPage.index', compact(
            'aboutUs'
        ));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'whole_page_status' => 'required|numeric|in:0,1',
            'slideshow_status' => 'required|numeric|in:0,1',
            'slideshow_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000000',
            'bottom_body_status' => 'required|numeric|in:0,1',
            'bottom_body_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000000',
            'bottom_slideshow_status' => 'required|numeric|in:0,1',
            'bottom_slideshow_image' => 'nullable|image|mimes:jpg,jpeg,png|max:10000000'
        ]);

        $aboutUs = AboutUsPage::first();

        /*slideshow_image*/
        $slideshow_image = $aboutUs->slideshow_image ?? null;
        if(!empty($request['slideshow_image'])){
            try{
                unlink($aboutUs->slideshow_image);
            } catch(\Exception $e){}

            $sizes = getimagesize($request['slideshow_image']);
            $slideshow_image = store_image($request['slideshow_image'], 'aboutus', $sizes[0], $sizes[1]);
        }

        /*bottom_body_image*/
        $bottom_body_image = $aboutUs->bottom_body_image ?? null;
        if(!empty($request['bottom_body_image'])){
            try{
                unlink($aboutUs->bottom_body_image);
            } catch(\Exception $e){}

            $sizes = getimagesize($request['bottom_body_image']);
            $bottom_body_image = store_image($request['bottom_body_image'], 'aboutus', $sizes[0], $sizes[1]);
        }

        /*bottom_slideshow_image*/
        $bottom_slideshow_image = $aboutUs->bottom_slideshow_image ?? null;
        if(!empty($request['bottom_slideshow_image'])){
            try{
                unlink($aboutUs->bottom_slideshow_image);
            } catch(\Exception $e){}

            $sizes = getimagesize($request['bottom_slideshow_image']);
            $bottom_slideshow_image = store_image($request['bottom_slideshow_image'], 'aboutus', $sizes[0], $sizes[1]);
        }


        /*body_items*/
        $body_items_Array = null;
        $body_items_sort_orders = $request['body_items_sort_orders'];
        $body_items_titles = $request['body_items_titles'];
        $body_items_images = $request['body_items_images'];
        $body_items_texts = $request['body_items_texts'];
        if(!empty($body_items_sort_orders)){
            if(count($body_items_sort_orders)){
                foreach($body_items_sort_orders as $key=>$body_items_sort_order){
                    if(
                        $body_items_sort_order != '' &&
                        $body_items_titles[$key] != '' &&
                        $body_items_images[$key] != '' &&
                        $body_items_texts[$key] != ''
                    ){
                        /*Upload image*/
                        $thisFilePath = null;
                        if(!empty($body_items_images[$key])){
                            if(is_string($body_items_images[$key])){
                                /*STRINGe*/
                                $thisFilePath = $body_items_images[$key];
                            }
                            else{
                                /*FILEe*/
                                $file = $body_items_images[$key];
                                $filename = time().$file->getClientOriginalName();
                                $path = 'images/aboutus';
                                $file->move($path, $filename);
                                $thisFilePath = $path.'/'.$filename;
                            }
                        }

                        $body_items_Array[] = [
                            'sort_order' => $body_items_sort_order,
                            'title' => $body_items_titles[$key],
                            'image' => $thisFilePath,
                            'text' => $body_items_texts[$key]
                        ];
                    }
                }
                $body_items_Array = json_encode($body_items_Array);
            }
        }


        /*persons*/
        $persons_Array = null;
        $persons_sort_orders = $request['persons_sort_orders'];
        $persons_titles = $request['persons_titles'];
        $persons_images = $request['persons_images'];
        $persons_texts = $request['persons_texts'];
        if(!empty($persons_sort_orders)){
            if(count($persons_sort_orders)){
                foreach($persons_sort_orders as $key=>$persons_sort_order){
                    if(
                        $persons_sort_order != '' &&
                        $persons_titles[$key] != '' &&
                        $persons_images[$key] != '' &&
                        $persons_texts[$key] != ''
                    ){
                        /*Upload image*/
                        $thisFilePath = null;
                        if(!empty($persons_images[$key])){
                            if(is_string($persons_images[$key])){
                                /*STRINGe*/
                                $thisFilePath = $persons_images[$key];
                            }
                            else{
                                /*FILEe*/
                                $file = $persons_images[$key];
                                $filename = time().$file->getClientOriginalName();
                                $path = 'images/aboutus';
                                $file->move($path, $filename);
                                $thisFilePath = $path.'/'.$filename;
                            }
                        }

                        $persons_Array[] = [
                            'sort_order' => $persons_sort_order,
                            'title' => $persons_titles[$key],
                            'image' => $thisFilePath,
                            'text' => $persons_texts[$key]
                        ];
                    }
                }
                $persons_Array = json_encode($persons_Array);
            }
        }




        if(!empty($aboutUs)){
            $aboutUs->update([
                'whole_page_status' => $request['whole_page_status'],
                'slideshow_status' => $request['slideshow_status'],
                'slideshow_image' => $slideshow_image,
                'slideshow_title' => $request['slideshow_title'],
                'slideshow_text' => $request['slideshow_text'],
                'slideshow_button_title' => $request['slideshow_button_title'],
                'slideshow_button_link' => $request['slideshow_button_link'],
                'body' => $request['body'],
                'body_items' => $body_items_Array,
                'bottom_body_status' => $request['bottom_body_status'],
                'bottom_body_image' => $bottom_body_image,
                'bottom_body_title' => $request['bottom_body_title'],
                'bottom_body_text' => $request['bottom_body_text'],
                'persons' => $persons_Array,
                'bottom_slideshow_status' => $request['bottom_slideshow_status'],
                'bottom_slideshow_image' => $bottom_slideshow_image,
                'bottom_slideshow_title' => $request['bottom_slideshow_title'],
                'bottom_slideshow_text' => $request['bottom_slideshow_text'],
                'bottom_slideshow_button_title' => $request['bottom_slideshow_button_title'],
                'bottom_slideshow_button_link' => $request['bottom_slideshow_button_link'] ,

                'seo_title' => $request['seo_title'],
                'seo_description' => $request['seo_description'],
                'seo_keywords' => $request['seo_keywords']
            ]);
        }
        else{
            AboutUsPage::create([
                'whole_page_status' => $request['whole_page_status'],
                'slideshow_status' => $request['slideshow_status'],
                'slideshow_image' => $slideshow_image,
                'slideshow_title' => $request['slideshow_title'],
                'slideshow_text' => $request['slideshow_text'],
                'slideshow_button_title' => $request['slideshow_button_title'],
                'slideshow_button_link' => $request['slideshow_button_link'],
                'body' => $request['body'],
                'body_items' => $body_items_Array,
                'bottom_body_status' => $request['bottom_body_status'],
                'bottom_body_image' => $bottom_body_image,
                'bottom_body_title' => $request['bottom_body_title'],
                'bottom_body_text' => $request['bottom_body_text'],
                'persons' => $persons_Array,
                'bottom_slideshow_status' => $request['bottom_slideshow_status'],
                'bottom_slideshow_image' => $bottom_slideshow_image,
                'bottom_slideshow_title' => $request['bottom_slideshow_title'],
                'bottom_slideshow_text' => $request['bottom_slideshow_text'],
                'bottom_slideshow_button_title' => $request['bottom_slideshow_button_title'],
                'bottom_slideshow_button_link' => $request['bottom_slideshow_button_link'],

                'seo_title' => $request['seo_title'],
                'seo_description' => $request['seo_description'],
                'seo_keywords' => $request['seo_keywords']
            ]);
        }

        flash_message('success', __('labels.stored'), '');
        return back();
    }

}






