<?php

if (! function_exists('MainHelper_createNumberCode')) {
    function MainHelper_createNumberCode($length = 4)
    {
        $code = rand(pow(10, $length - 1), pow(10, $length) - 1);
        return $code;
    }
}

if (! function_exists('MainHelper_checkCodeMelli')) {
    function MainHelper_checkCodeMelli($value)
    {
        if (!preg_match('/^[0-9]{10}$/', $value))
            return false;
        for ($i = 0; $i < 10; $i++)
            if (preg_match('/^' . $i . '{10}$/', $value))
                return false;
        for ($i = 0, $sum = 0; $i < 9; $i++)
            $sum += ((10 - $i) * intval(substr($value, $i, 1)));
        $ret = $sum % 11;
        $parity = intval(substr($value, 9, 1));
        if (($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity))
            return true;
        return false;
    }
}

if (! function_exists('MainHelper_storeAlertNotification')) {
    function MainHelper_storeAlertNotification($user_id, $company_id, $type, $title, $text)
    {
        \App\Models\AlertNotification::create([
            'user_id' => $user_id,
            'company_id' => $company_id,
            'type' => $type,
            'title' => $title,
            'text' => $text,
            'seen' => false
        ]);

        return 'DONE';
    }
}

if (! function_exists('settings')) {
    function settings($name)
    {
        $settings = Cache::rememberForever('settings', function () {
            return \App\Models\Setting::query()->select('name', 'value')->get();
        });

        return optional($settings->firstWhere('name', $name))->value;
    }
}
