<?php

function convert_to_jalali($date)
{
    /*تاریخ قمری رو فرستادم اینجا و آماده میکنم واسه فانکشن زیرینش که به شمسی تبدیلش کنه*/
    $array = explode('-', $date);
    $persian_date_array = gregorian_to_jalali($array[0], $array[1], $array[2]);
    $persian_date_array = implode('/', $persian_date_array);
    return $persian_date_array;
}

function gregorian_to_jalali($gy,$gm,$gd,$mod=''){
    /*فانکشن کپی - تبدیل تاریخ قمری به شمسی*/
    $g_d_m=array(0,31,59,90,120,151,181,212,243,273,304,334);
    if($gy>1600){
        $jy=979;
        $gy-=1600;
    }else{
        $jy=0;
        $gy-=621;
    }
    $gy2=($gm>2)?($gy+1):$gy;
    $days=(365*$gy) +((int)(($gy2+3)/4)) -((int)(($gy2+99)/100)) +((int)(($gy2+399)/400)) -80 +$gd +$g_d_m[$gm-1];
    $jy+=33*((int)($days/12053));
    $days%=12053;
    $jy+=4*((int)($days/1461));
    $days%=1461;
    if($days > 365){
        $jy+=(int)(($days-1)/365);
        $days=($days-1)%365;
    }
    $jm=($days < 186)?1+(int)($days/31):7+(int)(($days-186)/30);
    $jd=1+(($days < 186)?($days%31):(($days-186)%30));
    return($mod=='')?array($jy,$jm,$jd):$jy.$mod.$jm.$mod.$jd;
}

function convert_to_gregorian($date)
{
    /*تاریخ شمسی رو فرستادم اینجا و آماده میکنم واسه فانکشن زیرینش که به قمری تبدیلش کنه*/
    $array = explode('/', $date);
    $persian_date_array = jalali_to_gregorian($array[0], $array[1], $array[2]);
    $persian_date_array = implode('/', $persian_date_array);
    return $persian_date_array;
}

function jalali_to_gregorian($jy,$jm,$jd,$mod=''){
    if($jy>979){
        $gy=1600;
        $jy-=979;
    }else{
        $gy=621;
    }
    $days=(365*$jy) +(((int)($jy/33))*8) +((int)((($jy%33)+3)/4)) +78 +$jd +(($jm<7)?($jm-1)*31:(($jm-7)*30)+186);
    $gy+=400*((int)($days/146097));
    $days%=146097;
    if($days > 36524){
        $gy+=100*((int)(--$days/36524));
        $days%=36524;
        if($days >= 365)$days++;
    }
    $gy+=4*((int)($days/1461));
    $days%=1461;
    if($days > 365){
        $gy+=(int)(($days-1)/365);
        $days=($days-1)%365;
    }
    $gd=$days+1;
    foreach(array(0,31,(($gy%4==0 and $gy%100!=0) or ($gy%400==0))?29:28 ,31,30,31,30,31,31,30,31,30,31) as $gm=>$v){
        if($gd<=$v)break;
        $gd-=$v;
    }
    return($mod=='')?array($gy,$gm,$gd):$gy.$mod.$gm.$mod.$gd;
}

/*
 * Tarikh ro injury bargardoone
 * 1400 bahman 07
 */
function dateTime_displayDateInHumanStyle($date)
{
    $persianStringDate = convert_to_jalali($date->toDateString());

    $array = explode('/', $persianStringDate);
    $year = $array[0];
    $month = $array[1];
    $day = $array[2];

    switch ($month){
        case 1:
            $monthString = 'فروردین';
            break;
        case 2:
            $monthString = 'اردیبهشت';
            break;
        case 3:
            $monthString = 'خرداد';
            break;
        case 4:
            $monthString = 'تیر';
            break;
        case 5:
            $monthString = 'امرداد';
            break;
        case 6:
            $monthString = 'شهریور';
            break;
        case 7:
            $monthString = 'مهر';
            break;
        case 8:
            $monthString = 'آبان';
            break;
        case 9:
            $monthString = 'آذر';
            break;
        case 10:
            $monthString = 'دی';
            break;
        case 11:
            $monthString = 'بهمن';
            break;
        case 12:
            $monthString = 'اسفند';
            break;
    }

    return $day . ' ' . $monthString .' '.$year;
}
